/*!
 * Button visually impaired v2.0
 */
(function ($) {
    "use strict";
    $.bvi = function (options) {
        var default_setting = $.extend({
            'bvi_target': '.bvi-open',
            'bvi_theme': 'white',
            'bvi_font': 'arial',
            'bvi_font_size': 16,
            'bvi_letter_spacing': 'normal',
            'bvi_line_height': 'normal',
            'bvi_images': true,
            'bvi_reload': false,
            'bvi_fixed': true,
            'bvi_tts': true,
            'bvi_flash_iframe': true,
            'bvi_hide': false
        }, options);

        var versionIE = detectIE();
        var selector = default_setting.bvi_target;
        var check_bvi_theme;
        var check_bvi_font;
        var check_bvi_letter_spacing;
        var check_bvi_line_height;
        var check_bvi_font_size;
        var check_bvi_images;
        var check_bvi_fixed;
        var check_bvi_tts;
        var check_bvi_flash_iframe;
        var check_bvi_hide;
        var checkError;
        var bvi_tts_synth = window.speechSynthesis;
        var bvi_tts_support_browser = (bvi_tts_synth !== undefined) ? true : false;
        var sm = '576';
        var md = '768';
        var lg = '992';
        var xl = '1200';
        var width = (window.innerWidth > 0) ? window.innerWidth : screen.width;

        console.log('Bvi console: ready Button visually impaired v2.0');

        if (bvi_tts_support_browser) {
            setInterval(function () {
                if (bvi_tts_synth.speaking == false) {
                    $('.bvi-tts-play').removeClass('disabled');
                    $('.bvi-tts-pause').addClass('disabled');
                    $('.bvi-tts-resume').addClass('disabled');
                    $('.bvi-tts-stop').addClass('disabled');
                }
            }, 1000);
            console.log('Bvi console: Чтение речи поддерживается в данной браузере');
        } else {
            console.log('Bvi console: Чтение речи не поддерживается в данном браузере');
        }

        $(window).on('resize', function () {
            var width_resize = (window.innerWidth > 0) ? window.innerWidth : screen.width;

            if (width_resize >= lg) {
                $('.bvi-panel-container').show();
            }

            if (width_resize <= lg) {
                $('.bvi-panel-container').removeClass('bvi-container').addClass('bvi-container-fluid');
            } else {
                $('.bvi-panel-container').removeClass('bvi-container-fluid').addClass('bvi-container');
            }
        });

        function detectIE() {
            var ua = window.navigator.userAgent;
            var msie = ua.indexOf('MSIE ');

            if (msie > 0) {
                return parseInt(ua.substring(msie + 5, ua.indexOf('.', msie)), 10);
            }

            var trident = ua.indexOf('Trident/');
            if (trident > 0) {
                var rv = ua.indexOf('rv:');
                return parseInt(ua.substring(rv + 3, ua.indexOf('.', rv)), 10);
            }

            var edge = ua.indexOf('Edge/');
            if (edge > 0) {
                return parseInt(ua.substring(edge + 5, ua.indexOf('.', edge)), 10);
            }

            return false;
        }

        function bvi_tts_speak(text) {
            if (Cookies.get('bvi-tts') === 'true' && bvi_tts_support_browser) {
                bvi_tts_synth.cancel();
                var voices = bvi_tts_synth.getVoices();
                var chunkLength = 120;
                var pattRegex = new RegExp('^[\\s\\S]{' + Math.floor(chunkLength / 2) + ',' + chunkLength + '}[.!?,]{1}|^[\\s\\S]{1,' + chunkLength + '}$|^[\\s\\S]{1,' + chunkLength + '} ');
                var $array = [];
                var $text = text;

                while ($text.length > 0) {
                    $array.push($text.match(pattRegex)[0]);
                    $text = $text.substring($array[$array.length - 1].length);
                }

                $.each($array, function () {
                    var speechUtterance = new SpeechSynthesisUtterance(this.trim());
                    speechUtterance.volume = 1;
                    speechUtterance.rate = 1;
                    speechUtterance.pitch = 1;
                    speechUtterance.lang = 'ru-RU';

                    speechUtterance.onstart = function (event) {
                        console.log(speechUtterance);
                        //console.log('Start called for: ' + event.utterance.text + '-' + event.charIndex);
                    };

                    speechUtterance.onend = function (event) {
                        //console.log(event.name + ' end ' + event.elapsedTime + ' milliseconds.');
                    };

                    speechUtterance.onpause = function (event) {
                        //console.log(event.name + ' pause ' + event.elapsedTime + ' milliseconds.');
                    };

                    speechUtterance.onresume = function (event) {
                        //console.log(event.name + ' resume ' + event.elapsedTime + ' milliseconds.');
                    };

                    speechUtterance.onboundary = function (event) {
                        /*
                        var world = bvi_getWordAt(event.utterance.text, event.charIndex);
                        var src_str = $(id).text();
                        var term = world.replace(/(\s+)/, "(<[^>]+>)*$1(<[^>]+>)*");
                        var pattern = new RegExp("(" + term + ")", "gi");
                        src_str = src_str.replace(pattern, "<mark>$1</mark>");
                        src_str = src_str.replace(/(<mark>[^<>]*)((<[^>]+>)+)([^<>]*<\/mark>)/, "$1</mark>$2<mark>$4");
                        $(id).html(src_str);
                        console.log(event.utterance.text);
                        */
                    };

                    for (var i = 0; i < voices.length; i++) {
                        if (voices[i].lang === 'ru-RU' && voices[i].voiceURI === 'Google русский') {
                            speechUtterance.voice = voices[i];
                            speechUtterance.voiceURI = voices[i].voiceURI;
                        } else if (voices[i].lang === 'ru-RU' && voices[i].voiceURI === 'Microsoft Irina Desktop - Russian') {
                            speechUtterance.voice = voices[i];
                            speechUtterance.voiceURI = voices[i].voiceURI;
                        } else if (voices[i].lang === 'ru-RU' && voices[i].voiceURI === 'urn:moz-tts:sapi:Microsoft Irina Desktop - Russian?ru-RU') {
                            speechUtterance.voice = voices[i];
                            speechUtterance.voiceURI = voices[i].voiceURI;
                        } else if (voices[i].lang === 'ru-RU' && voices[i].voiceURI === 'com.apple.speech.synthesis.voice.yuri') {
                            speechUtterance.voice = voices[i];
                            speechUtterance.voiceURI = voices[i].voiceURI;
                        }
                    }

                    bvi_tts_synth.speak(speechUtterance);
                });
            }
        }

        function bvi_getWordAt(str, pos) {
            str = String(str);
            pos = Number(pos) >>> 0;
            var left = str.slice(0, pos + 1).search(/\S+$/),
                right = str.slice(pos).search(/\s/);
            if (right < 0) {
                return str.slice(left);
            }
            return str.slice(left, right + pos);
        }

        function bvi_tts_player() {
            var bvi_tts_text_id;
            var bvi_tts_voice_target = $(".bvi-tts");

            $('.bvi-tts-link').remove();
            $('.bvi-tts-text').contents().unwrap();

            if (Cookies.get('bvi-tts') === 'true' && bvi_tts_support_browser) {
                bvi_tts_voice_target.each(function (index) {
                    bvi_tts_text_id = 'bvi-tts-text-id-' + index;
                    $(this).wrapInner('<div class="bvi-tts-text ' + bvi_tts_text_id + '"></div>');
                    $(this).prepend('<div class="bvi-tts-link bvi-tts-link-id-' + index + '" data-bvi-tts-class-text=".' + bvi_tts_text_id + '" data-bvi-tts-link-id=".bvi-tts-link-id-' + index + '">\n' +
                        '    <a href="#" class="bvi-tts-play bvi-link">Воспроизвести</a>\n' +
                        '    <a href="#" class="bvi-tts-pause bvi-link disabled">Пауза</i></a>\n' +
                        '    <a href="#" class="bvi-tts-resume bvi-link disabled">Продолжить</i></a>\n' +
                        '    <a href="#" class="bvi-tts-stop bvi-link disabled">Стоп</i></a>\n' +
                        '</div>');
                });

                $('.bvi-tts-link').show();

                $('.bvi-tts-play').click(function () {
                    bvi_tts_synth.cancel();
                    var bvi_tts_class = $(this).parent().data('bvi-tts-class-text');
                    var bvi_tts_links_id = $(this).parent().data('bvi-tts-link-id');
                    var bvi_tts_class_text = $(bvi_tts_class).text();

                    bvi_tts_speak(bvi_tts_class_text);

                    $('.bvi-tts-play').removeClass('disabled');
                    $('.bvi-tts-pause').addClass('disabled');
                    $('.bvi-tts-resume').addClass('disabled');
                    $('.bvi-tts-stop').addClass('disabled');
                    $(bvi_tts_links_id + ' .bvi-tts-play').addClass('disabled');
                    $(bvi_tts_links_id + ' .bvi-tts-pause').removeClass('disabled');
                    $(bvi_tts_links_id + ' .bvi-tts-stop').removeClass('disabled');
                    return false;
                });

                $('.bvi-tts-resume').click(function () {
                    var bvi_tts_links_id = $(this).parent().data('bvi-tts-link-id');
                    $(bvi_tts_links_id + ' .bvi-tts-pause').removeClass('disabled');
                    $(this).addClass('disabled');
                    bvi_tts_synth.resume();
                    return false;
                });

                $('.bvi-tts-pause').click(function () {
                    var bvi_tts_links_id = $(this).parent().data('bvi-tts-link-id');
                    $(bvi_tts_links_id + ' .bvi-tts-resume').removeClass('disabled');
                    $(this).addClass('disabled');
                    bvi_tts_synth.pause();
                    return false;
                });

                $('.bvi-tts-stop').click(function () {
                    bvi_tts_synth.cancel();
                    var bvi_tts_links_id = $(this).parent().data('bvi-tts-link-id');
                    $(this).addClass('disabled');
                    $(bvi_tts_links_id + ' .bvi-tts-play').removeClass('disabled');
                    $(bvi_tts_links_id + ' .bvi-tts-pause').addClass('disabled');
                    $(bvi_tts_links_id + ' .bvi-tts-resume').addClass('disabled');
                    return false;
                });
            } else {
                $('.bvi-tts-link').remove();
                $('.bvi-tts-text').contents().unwrap();
            }
        }

        function bvi_click() {
            $("#bvi-panel-close, .bvi-panel-close, #bvi-toggler-close").click(function () {

                bvi_tts_speak('Обычная версия сайта');

                if (Cookies.get("bvi-reload") === 'true') {
                    document.location.reload(true);
                }

                $(".bvi-body *").each(function () {
                    var $this = $(this);
                    var background_image = $this.css("background-image");
                    var pattern = background_image.replace(/.*\s?url\([\'\"]?/, '').replace(/[\'\"]?\).*/, '');
                    if (pattern != 'none') {
                        if (versionIE == 11 || versionIE == 10 || versionIE == 9) {
                            var data_bvi_img_original = $this.attr('data-bvi-background-image-original') || pattern;
                            $this.css("background-image", "url(" + data_bvi_img_original + ")");
                            $this.removeClass('bvi-background-image');
                        }
                    }
                });

                $("img").each(function () {
                    $(this).show();
                    $('div.bvi-img').remove();
                    $(this).removeClass("bvi-background-image");
                    if (versionIE == 11 || versionIE == 10 || versionIE == 9) {
                        var data_bvi_img_original = $(this).attr('data-bvi-img-original') || this.src;
                        this.src = data_bvi_img_original;
                    }
                });

                Cookies.remove("bvi-panel-active", {path: "/"});
                Cookies.remove("bvi-font-size", {path: "/"});
                Cookies.remove("bvi-theme", {path: "/"});
                Cookies.remove("bvi-images", {path: "/"});
                Cookies.remove("bvi-line-height", {path: "/"});
                Cookies.remove("bvi-letter-spacing", {path: "/"});
                Cookies.remove("bvi-tts", {path: "/"});
                Cookies.remove("bvi-font-family", {path: "/"});
                Cookies.remove("bvi-panel-hide", {path: "/"});
                Cookies.remove("bvi-flash-iframe", {path: "/"});
                Cookies.remove("bvi-reload", {path: "/"});

                active();
                return false;
            });

            $('#bvi-panel-hide, #bvi-toggler-menu-hide').click(function () {
                $('.bvi-panel').toggle(0);
                $('.bvi-link-top').toggle(0);
                set('data-bvi-panel-hide', 'bvi-panel-hide', true);
                bvi_tts_speak('Панель скрыта');
                return false;
            });

            $('#bvi-panel-show').click(function () {
                $('.bvi-panel').toggle(0);
                $('.bvi-link-top').toggle(0);
                set('data-bvi-panel-hide', 'bvi-panel-hide', false);
                bvi_tts_speak('Панель открыта');
                return false;
            });

            $('#bvi-setting').click(function () {
                $('.bvi-setting-menu').toggle(0);
                $(this).toggleClass("active");
                bvi_tts_speak('Дополнительные настройки');
                return false;
            });

            $('#bvi-toggler').click(function () {
                $('.bvi-panel-container').toggle(0);
                $(this).toggleClass("active");
                bvi_tts_speak('Меню');
                return false;
            });

            $('#bvi-setting-close').click(function () {
                $('.bvi-setting-menu').toggle(0);
                $('#bvi-setting').toggleClass("active");
                bvi_tts_speak('Дополнительные настройки закрыты');
                return false;
            });

            $('#bvi-font-size-less').click(function () {
                var size = parseFloat(Cookies.get("bvi-font-size")) - 1;
                $(this).addClass('active').siblings().removeClass('active');
                $('#bvi-font-size').text(size);
                if (size != 0) {
                    set('data-bvi-size', 'bvi-font-size', size);
                    bvi_tts_speak('Размер шрифта уменьшен');
                }
                return false;
            });

            $('#bvi-font-size-more').click(function () {
                var size = parseFloat(Cookies.get("bvi-font-size")) + 1;
                $(this).addClass('active').siblings().removeClass('active');
                $('#bvi-font-size').text(size);
                if (size != 40) {
                    set('data-bvi-size', 'bvi-font-size', size);
                    bvi_tts_speak('Размер шрифта увеличен');
                }
                return false;
            });

            $("#bvi-theme-white").click(function () {
                $(this).addClass('active').siblings().removeClass('active');
                set('data-bvi-theme', 'bvi-theme', 'white');
                bvi_tts_speak('Цвет сайта черным по белому');
                return false;
            });

            $("#bvi-theme-black").click(function () {
                $(this).addClass('active').siblings().removeClass('active');
                set('data-bvi-theme', 'bvi-theme', 'black');
                bvi_tts_speak('Цвет сайта белым по черному');
                return false;
            });

            $("#bvi-theme-blue").click(function () {
                $(this).addClass('active').siblings().removeClass('active');
                set('data-bvi-theme', 'bvi-theme', 'blue');
                bvi_tts_speak('Цвет сайта тёмно-синим по голубому');
                return false;
            });

            $("#bvi-theme-brown").click(function () {
                $(this).addClass('active').siblings().removeClass('active');
                set('data-bvi-theme', 'bvi-theme', 'brown');
                bvi_tts_speak('Цвет сайта коричневым по бежевому');
                return false;
            });

            $("#bvi-theme-green").click(function () {
                $(this).addClass('active').siblings().removeClass('active');
                set('data-bvi-theme', 'bvi-theme', 'green');
                bvi_tts_speak('Цвет сайта зеленым по тёмно-коричневому');
                return false;
            });

            $('#bvi-images-true').click(function () {
                $(this).addClass('active').siblings().removeClass('active');
                set('data-bvi-images', 'bvi-images', true);
                bvi_tts_speak('Изображения включены');
                return false;
            });

            $('#bvi-images-false').click(function () {
                $(this).addClass('active').siblings().removeClass('active');
                set('data-bvi-images', 'bvi-images', false);
                bvi_tts_speak('Изображения выключены');
                return false;
            });

            $('#bvi-images-grayscale').click(function () {
                $(this).addClass('active').siblings().removeClass('active');
                set('data-bvi-images', 'bvi-images', 'grayscale');
                bvi_tts_speak('Изображения чёрно-белые');
                return false;
            });

            $("#bvi-line-height-normal").click(function () {
                $(this).addClass('active').siblings().removeClass('active');
                set('data-bvi-line-height', 'bvi-line-height', 'normal');
                bvi_tts_speak('Междустрочный интервал cтандартный');
                return false;
            });

            $("#bvi-line-height-average").click(function () {
                $(this).addClass('active').siblings().removeClass('active');
                set('data-bvi-line-height', 'bvi-line-height', 'average');
                bvi_tts_speak('Междустрочный интервал средний');
                return false;
            });

            $("#bvi-line-height-big").click(function () {
                $(this).addClass('active').siblings().removeClass('active');
                set('data-bvi-line-height', 'bvi-line-height', 'big');
                bvi_tts_speak('Междустрочный интервал большой');
                return false;
            });

            $("#bvi-letter-spacing-normal").click(function () {
                $(this).addClass('active').siblings().removeClass('active');
                set('data-bvi-letter-spacing', 'bvi-letter-spacing', 'normal');
                bvi_tts_speak('Межбуквенный интервал одинарный');
                return false;
            });

            $("#bvi-letter-spacing-average").click(function () {
                $(this).addClass('active').siblings().removeClass('active');
                set('data-bvi-letter-spacing', 'bvi-letter-spacing', 'average');
                bvi_tts_speak('Межбуквенный интервал полуторный');
                return false;
            });

            $("#bvi-letter-spacing-big").click(function () {
                $(this).addClass('active').siblings().removeClass('active');
                set('data-bvi-letter-spacing', 'bvi-letter-spacing', 'big');
                bvi_tts_speak('Межбуквенный интервал двойной');
                return false;
            });

            $("#bvi-font-family-arial").click(function () {
                $(this).addClass('active').siblings().removeClass('active');
                set('data-bvi-font-family', 'bvi-font-family', 'arial');
                bvi_tts_speak('Шрифт без засечек');
                return false;
            });

            $("#bvi-font-family-times").click(function () {
                $(this).addClass('active').siblings().removeClass('active');
                set('data-bvi-font-family', 'bvi-font-family', 'times');
                bvi_tts_speak('Шрифт с засечками');
                return false;
            });

            $("#bvi-flash-iframe-true").click(function () {
                $(this).addClass('active').siblings().removeClass('active');
                set('data-bvi-flash-iframe', 'bvi-flash-iframe', true);
                bvi_tts_speak('Включить встроенные элементы');
                return false;
            });

            $("#bvi-flash-iframe-false").click(function () {
                $(this).addClass('active').siblings().removeClass('active');
                set('data-bvi-flash-iframe', 'bvi-flash-iframe', false);
                bvi_tts_speak('Выключить встроенные элементы');
                return false;
            });

            $("#bvi-tts-true").click(function () {
                $(this).addClass('active').siblings().removeClass('active');
                set('data-bvi-tts', 'bvi-tts', true);
                bvi_tts_speak('Синтез речи включён');
                bvi_tts_player();
                return false;
            });

            $("#bvi-tts-false").click(function () {
                $(this).addClass('active').siblings().removeClass('active');
                set('data-bvi-tts', 'bvi-tts', false);
                bvi_tts_speak('Синтез речи выключён');
                bvi_tts_player();
                return false;
            });

            $("#bvi-settings-default").click(function () {
                $('#bvi-theme-' + Cookies.get("bvi-theme")).removeClass('active');
                $('#bvi-images-' + Cookies.get("bvi-images")).removeClass('active');
                $('#bvi-line-height-' + Cookies.get("bvi-line-height")).removeClass('active');
                $('#bvi-letter-spacing-' + Cookies.get("bvi-letter-spacing")).removeClass('active');
                $('#bvi-font-family-' + Cookies.get("bvi-font-family")).removeClass('active');
                $('#bvi-flash-iframe-' + Cookies.get("bvi-flash-iframe")).removeClass('active');
                $('#bvi-tts-' + Cookies.get("bvi-tts")).removeClass('active');

                $('#bvi-theme-' + default_setting.bvi_theme).addClass('active');
                $('#bvi-images-' + default_setting.bvi_images).addClass('active');
                $('#bvi-line-height-' + default_setting.bvi_line_height).addClass('active');
                $('#bvi-letter-spacing-' + default_setting.bvi_letter_spacing).addClass('active');
                $('#bvi-font-family-' + default_setting.bvi_font).addClass('active');
                $('#bvi-flash-iframe-' + default_setting.bvi_flash_iframe).addClass('active');
                $('#bvi-tts-' + default_setting.bvi_tts).addClass('active');

                $('#bvi-font-size').text(default_setting.bvi_font_size);

                set('data-bvi-size', 'bvi-font-size', default_setting.bvi_font_size);
                set('data-bvi-theme', 'bvi-theme', default_setting.bvi_theme);
                set('data-bvi-images', 'bvi-images', default_setting.bvi_images);
                set('data-bvi-line-height', 'bvi-line-height', default_setting.bvi_line_height);
                set('data-bvi-letter-spacing', 'bvi-letter-spacing', default_setting.bvi_letter_spacing);
                set('data-bvi-font-family', 'bvi-font-family', default_setting.bvi_font);
                set('data-bvi-flash-iframe', 'bvi-flash-iframe', default_setting.bvi_flash_iframe);
                set('data-bvi-tts', 'bvi-tts', default_setting.bvi_tts);
                bvi_tts_speak('Настройки по умолчанию');
                bvi_tts_player();
                return false;
            });
        }

        function set(data, set_cookies, set_cookies_data) {
            Cookies.set(set_cookies, set_cookies_data, {path: "/", expires: 1});
            $(".bvi-body").attr(data, Cookies.get(set_cookies));
            get_image();
        }

        function set_active_link() {
            $('#bvi-theme-' + Cookies.get("bvi-theme")).addClass('active');
            $('#bvi-images-' + Cookies.get("bvi-images")).addClass('active');
            $('#bvi-line-height-' + Cookies.get("bvi-line-height")).addClass('active');
            $('#bvi-letter-spacing-' + Cookies.get("bvi-letter-spacing")).addClass('active');
            $('#bvi-font-family-' + Cookies.get("bvi-font-family")).addClass('active');
            $('#bvi-flash-iframe-' + Cookies.get("bvi-flash-iframe")).addClass('active');
            $('#bvi-tts-' + Cookies.get("bvi-tts")).addClass('active');
        }

        function get() {
            if (typeof Cookies.get("bvi-font-size") === 'undefined'
                || typeof Cookies.get("bvi-theme") === 'undefined'
                || typeof Cookies.get("bvi-images") === 'undefined'
                || typeof Cookies.get("bvi-line-height") === 'undefined'
                || typeof Cookies.get("bvi-letter-spacing") === 'undefined'
                || typeof Cookies.get("bvi-tts") === 'undefined'
                || typeof Cookies.get("bvi-font-family") === 'undefined'
                || typeof Cookies.get("bvi-panel-hide") === 'undefined'
                || typeof Cookies.get("bvi-flash-iframe") === 'undefined'
                || typeof Cookies.get("bvi-reload") === 'undefined'
                || typeof Cookies.get("bvi-fixed") === 'undefined'
            ) {
                Cookies.set("bvi-font-size", default_setting.bvi_font_size, {path: "/", expires: 1});
                Cookies.set("bvi-theme", default_setting.bvi_theme, {path: "/", expires: 1});
                Cookies.set("bvi-images", default_setting.bvi_images, {path: "/", expires: 1});
                Cookies.set("bvi-line-height", default_setting.bvi_line_height, {path: "/", expires: 1});
                Cookies.set("bvi-letter-spacing", default_setting.bvi_letter_spacing, {path: "/", expires: 1});
                Cookies.set("bvi-tts", default_setting.bvi_tts, {path: "/", expires: 1});
                Cookies.set("bvi-font-family", default_setting.bvi_font, {path: "/", expires: 1});
                Cookies.set("bvi-panel-hide", default_setting.bvi_hide, {path: "/", expires: 1});
                Cookies.set("bvi-flash-iframe", default_setting.bvi_flash_iframe, {path: "/", expires: 1});
                Cookies.set("bvi-reload", default_setting.bvi_reload, {path: "/", expires: 1});
                Cookies.set("bvi-fixed", default_setting.bvi_fixed, {path: "/", expires: 1});
            }

            $('.bvi-body').attr({
                'data-bvi-panel-hide': Cookies.get("bvi-panel-hide"),
                'data-bvi-size': Cookies.get("bvi-font-size"),
                'data-bvi-theme': Cookies.get("bvi-theme"),
                'data-bvi-images': Cookies.get("bvi-images"),
                'data-bvi-line-height': Cookies.get("bvi-line-height"),
                'data-bvi-letter-spacing': Cookies.get("bvi-letter-spacing"),
                'data-bvi-font-family': Cookies.get("bvi-font-family"),
                'data-bvi-flash-iframe': Cookies.get("bvi-flash-iframe"),
                'data-bvi-reload': Cookies.get("bvi-reload"),
                'data-bvi-tts': Cookies.get("bvi-tts"),
                'data-bvi-fixed': Cookies.get("bvi-fixed")
            });

            $('#bvi-font-size').text(Cookies.get("bvi-font-size"));

            var bvi_panel = Cookies.get("bvi-panel-hide");

            if (bvi_panel === 'false' || typeof bvi_panel === 'undefined') {
                $('.bvi-panel').show();
                $('.bvi-link-top').hide();
            } else {
                $('.bvi-panel').hide();
                $('.bvi-link-top').show("slow");
            }
        }

        function get_image() {
            var bvi_images = Cookies.get("bvi-images");

            $(".bvi-body *").each(function () {
                var $this = $(this);
                var background_image = $this.css("background-image");
                var pattern = background_image.replace(/^url\(['"]?/,'').replace(/['"]?\)$/,'');

                if (pattern != 'none') {
                    $(this).addClass('bvi-background-image');
                }
            });

            $("img").each(function () {
                $(this).addClass('bvi-img');
            });

            if (bvi_images === 'true') {
                $("img").each(function () {
                    $(this).show();
                    $('div.bvi-img').remove();
                    //$(this).removeClass("bvi-background-image");
                    if (versionIE == 11 || versionIE == 10 || versionIE == 9) {
                        var data_bvi_img_original = $(this).attr('data-bvi-img-original') || this.src;
                        this.src = data_bvi_img_original;
                    }
                });

                $(".bvi-body *").each(function () {
                    var $this = $(this);
                    var background_image = $this.css("background-image");
                    var pattern = background_image.replace(/^url\(['"]?/,'').replace(/['"]?\)$/,'');
                    if (pattern != 'none') {
                        if (versionIE == 11 || versionIE == 10 || versionIE == 9) {
                            var r = '^(https?|http)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]';
                            if(pattern.match(r)) {
                                var data_bvi_img_original = $this.attr('data-bvi-background-image-original') || pattern;
                                $this.css("background-image", "url(" + data_bvi_img_original + ")");
                            }
                        }
                    }
                });
            }

            if (bvi_images === 'false') {
                $('div.bvi-img').remove();

                $("img").each(function () {
                    $(this).hide();
                    //$(this).removeClass("bvi-background-image");
                    var alt = this.alt || 'Изображение';
                    var imgClass = $(this).attr("class") || 'bvi-class-none';
                    var imgId = $(this).attr("id") || 'bvi-id-none';
                    $(this).after($('<div class="' + imgClass + '" id="' + imgId + '" style="width: ' + $(this).get(0).naturalWidth + 'px; height: 100%;">').html(alt));
                });
            }

            if (bvi_images === 'grayscale') {
                $("img").each(function () {
                    $(this).show();
                    $('div.bvi-img').remove();
                    //$(this).removeClass("bvi-background-image");
                    if (versionIE == 11 || versionIE == 10 || versionIE == 9) {
                        $(this).attr('data-bvi-img-original', this.src);
                        if (location.hostname === extractHostname(this.src)) {
                            var src = grayscale(this.src);
                            this.src = src;
                        } else {
                            return false;
                        }
                    }
                });

                $(".bvi-body *").each(function () {
                    var $this = $(this);
                    var background_image = $this.css("background-image");
                    var pattern = background_image.replace(/^url\(['"]?/,'').replace(/['"]?\)$/,'');
                    if (pattern != 'none') {
                        if (versionIE == 11 || versionIE == 10 || versionIE == 9) {
                            var r = '^(https?|http)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]';
                            if(pattern.match(r)) {
                                var src_pattern = grayscale(pattern);
                                $this.attr('data-bvi-background-image-original', pattern);
                                $this.css("background-image", "url(" + src_pattern + ") !important");
                            }
                        }
                    }
                });
            }
        }

        function extractHostname(url) {
            var hostname;
            if (url.indexOf("//") > -1) {
                hostname = url.split('/')[2];
            } else {
                hostname = url.split('/')[0];
            }
            hostname = hostname.split(':')[0];
            hostname = hostname.split('?')[0];

            return hostname;
        }

        function grayscale(src) {
            var canvas = document.createElement('canvas');
            var ctx = canvas.getContext('2d');
            var imgObj = new Image();
            //imgObj.crossOrigin = "Anonymous";
            imgObj.src = src;
            canvas.width = imgObj.naturalWidth || imgObj.offsetWidth || imgObj.width;
            canvas.height = imgObj.naturalHeight || imgObj.offsetHeight || imgObj.height;
            ctx.drawImage(imgObj, 0, 0);
            var imgPixels = ctx.getImageData(0, 0, canvas.width, canvas.height);

            for (var y = 0; y < imgPixels.height; y++) {
                for (var x = 0; x < imgPixels.width; x++) {
                    var i = (y * 4) * imgPixels.width + x * 4;
                    var avg = (imgPixels.data[i] + imgPixels.data[i + 1] + imgPixels.data[i + 2]) / 3;
                    imgPixels.data[i] = avg;
                    imgPixels.data[i + 1] = avg;
                    imgPixels.data[i + 2] = avg;
                }
            }

            ctx.putImageData(imgPixels, 0, 0, 0, 0, imgPixels.width, imgPixels.height);

            return canvas.toDataURL();
        }

        function active() {
            if (versionIE == 8 || versionIE == 7 || versionIE == 6 || versionIE == 5) {
                console.log('Bvi console: Браузер не поддерживается.');
                alert(confirm('Браузер не поддерживается.'));
            } else {
                if (Cookies.get('bvi-panel-active') === 'true') {
                    $(selector).addClass('bvi-hide').after($('<a href="#" class="bvi-panel-close" title="Обычная версия сайта">Обычная версия сайта</a>'));
                    panel();
                    bvi_tts_player();
                    bvi_click();
                    set_active_link();
                    if (bvi_tts_support_browser === false) {
                        Cookies.set("bvi-tts", false, {path: "/", expires: 1});
                        $('#bvi-tts-true').remove();
                        $('#bvi-tts-false').remove();
                    }
                } else {
                    bvi_tts_player();
                    $(selector).removeClass('bvi-hide');
                    $('.bvi-panel-close').remove();
                    $(".bvi-panel").remove();
                    $(".bvi-link-top").remove();
                    $('body > .bvi-body').contents().unwrap();
                    $('.bvi-tts-link').remove();
                    $('.bvi-tts-text').contents().unwrap();
                }
            }
        }

        function panel() {
            $('head').append('<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">');
            $('body').wrapInner('<div class="bvi-body"></div>');
            $('body').prepend('<div class="bvi-panel">\n' +
                '    <div class="bvi-container-fluid">\n' +
                '        <div class="bvi-row bvi-no-gutters">\n' +
                '            <div class="bvi-col-12">\n' +
                '                <div class="bvi-panel-toggler">\n' +
                '                    <a href="#" id="bvi-toggler" class="bvi-link" title="Меню">Меню</a>\n' +
                '                    <a href="#" id="bvi-toggler-close" class="bvi-link" title="Обычная версия сайта">Обычная версия сайта</a>\n' +
                '                    <a href="#" id="bvi-toggler-menu-hide" class="bvi-link" title="Скрыть панель"><i class="bvi-images bvi-images-minus-square-o "></i></a>\n' +
                '                </div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '    <div class="bvi-panel-container bvi-container">\n' +
                '        <div class="bvi-row bvi-no-gutters">\n' +
                '            <div class="bvi-col-6 bvi-col-sm-6 bvi-col-md-3 bvi-col-lg-3 bvi-col-xl-3 bvi-text-center">\n' +
                '                <div class="bvi-title">Размер шрифта <span id="bvi-font-size"></span> px</div>\n' +
                '                <a href="#" id="bvi-font-size-less" class="bvi-link" title="Уменьшить размер шрифта">A -</a>\n' +
                '                <a href="#" id="bvi-font-size-more" class="bvi-link" title="Увеличить размер шрифта">A +</a>\n' +
                '            </div>\n' +
                '            <div class="bvi-col-6 bvi-col-sm-6 bvi-col-md-3 bvi-col-lg-3 bvi-col-xl-3 bvi-text-center">\n' +
                '                <div class="bvi-title">Цвета сайта</div>\n' +
                '                <a href="#" id="bvi-theme-white" class="bvi-link bvi-link-white " title="Черным по белому">Ц</a>\n' +
                '                <a href="#" id="bvi-theme-black" class="bvi-link bvi-link-black" title="Белым по черному">Ц</a>\n' +
                '                <a href="#" id="bvi-theme-blue" class="bvi-link bvi-link-blue" title="Темно-синим по голубому">Ц</a>\n' +
                '                <a href="#" id="bvi-theme-brown" class="bvi-link bvi-link-brown" title="Коричневым по бежевому">Ц</a>\n' +
                '                <a href="#" id="bvi-theme-green" class="bvi-link bvi-link-green" title="Зеленым по темно-коричневому">Ц</a>\n' +
                '            </div>\n' +
                '            <div class="bvi-col-6 bvi-col-sm-6 bvi-col-md-3 bvi-col-lg-3 bvi-col-xl-2 bvi-text-center">\n' +
                '                <div class="bvi-title">Изображения</div>\n' +
                '                <a href="#" id="bvi-images-true" class="bvi-link" title="Изображения включены"><i class="bvi-images bvi-images-on"></i></a>\n' +
                '                <a href="#" id="bvi-images-false" class="bvi-link" title="Изображения выключены"><i class="bvi-images bvi-images-off"></i></a>\n' +
                '                <a href="#" id="bvi-images-grayscale" class="bvi-link" title="Изображения черно-белые"><i class="bvi-images bvi-images-adjust"></i></a>\n' +
                '            </div>\n' +
                '            <div class="bvi-col-6 bvi-col-sm-6 bvi-col-md-3 bvi-col-lg-3 bvi-col-xl-4 bvi-text-center">\n' +
                '                <div class="bvi-title">Дополнительно</div>\n' +
                '                <a href="#" id="bvi-tts-true" class="bvi-link" title=""><i class="bvi-images bvi-images-volume-on"></i></a>\n' +
                '                <a href="#" id="bvi-tts-false" class="bvi-link"><i class="bvi-images bvi-images-volume-off"></i></a>\n' +
                '                <a href="#" id="bvi-setting" class="bvi-link" title="Настройки">Настройки</a>\n' +
                '                <a href="#" id="bvi-panel-close" class="bvi-link" title="Обычная версия сайта"><i class="bvi-images bvi-images-eye-slash"></i></a>\n' +
                '                <a href="#" id="bvi-panel-hide" class="bvi-link" title="Скрыть панель"><i class="bvi-images bvi-images-minus-square-o"></i></a>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '        <div class="bvi-setting-menu bvi-hide-lg">\n' +
                '            <div class="bvi-row bvi-no-gutters">\n' +
                '                <div class="bvi-col-sm-12 bvi-col-md-6 bvi-col-lg-4 bvi-col-xl-4 bvi-text-center">\n' +
                '                    <div class="bvi-title">Междустрочный интервал</div>\n' +
                '                    <a href="#" id="bvi-line-height-normal" class="bvi-link" title="Междустрочный интервал стандартный">Стандартный</a>\n' +
                '                    <a href="#" id="bvi-line-height-average" class="bvi-link" title="Междустрочный интервал средний">Средний</a>\n' +
                '                    <a href="#" id="bvi-line-height-big" class="bvi-link" title="Междустрочный интервал большой">Большой</a>\n' +
                '                </div>\n' +
                '                <div class="bvi-col-sm-12 bvi-col-md-6 bvi-col-lg-5 bvi-col-xl-5 bvi-text-center">\n' +
                '                    <div class="bvi-title">Межбуквенный интервал</div>\n' +
                '                    <a href="#" id="bvi-letter-spacing-normal" class="bvi-link" title="Межбуквенный интервал одинарный">Одинарный</a>\n' +
                '                    <a href="#" id="bvi-letter-spacing-average" class="bvi-link"\n' +
                '                       title="Межбуквенный интервал полуторный">Полуторный</a>\n' +
                '                    <a href="#" id="bvi-letter-spacing-big" class="bvi-link" title="Межбуквенный интервал двойной">Двойной</a>\n' +
                '                </div>\n' +
                '                <div class="bvi-col-sm-12 bvi-col-md-6 bvi-col-lg-3 bvi-col-xl-3 bvi-text-center">\n' +
                '                    <div class="bvi-title">Шрифт</div>\n' +
                '                    <a href="#" id="bvi-font-family-arial" class="bvi-link" title="Шрифт без засечек">Без засечек</a>\n' +
                '                    <a href="#" id="bvi-font-family-times" class="bvi-link" title="Шрифт с засечками">С засечками</a>\n' +
                '                </div>\n' +
                '                <div class="bvi-col-sm-12 bvi-col-md-6 bvi-col-lg-6 bvi-col-xl-6 bvi-text-center">\n' +
                '                    <div class="bvi-title">Встроенные элементы (Видео, карты и тд.)</div>\n' +
                '                    <a href="#" id="bvi-flash-iframe-true" class="bvi-link" title="Включить">Включить</a>\n' +
                '                    <a href="#" id="bvi-flash-iframe-false" class="bvi-link" title="Выключить">Выключить</a>\n' +
                '                </div>\n' +
                '                <div class="bvi-col-sm-12 bvi-col-md-12 bvi-col-lg-6 bvi-col-xl-6 bvi-text-right">\n' +
                '                    <div class="bvi-title">&nbsp;</div>\n' +
                '                    <a href="#" id="bvi-settings-default" class="bvi-link" title="Вернуть стандартные настройки">Настройки\n' +
                '                        по умолчанию</a>\n' +
                '                    <a href="#" id="bvi-setting-close" class="bvi-link" title="Закрыть панель">Закрыть панель</a>\n' +
                '                </div>\n' +
                '            </div>\n' +
                '            <div class="bvi-row bvi-mt">\n' +
                '                <div class="bvi-col-12 bvi-text-center">\n' +
                '                    <a href="http://bvi.isvek.ru/" class="bvi-link-copy" target="_blank" title="bvi.isvek.ru v2.0">bvi.isvek.ru</a>\n' +
                '                </div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '</div>\n' +
                '<a href="#" id="bvi-panel-show" class="bvi-link bvi-link-top"><i class="bvi-images bvi-images-eye"></i></a>');

            if (width >= lg) {
                $('.bvi-panel-container').show();
            }

            if (width <= lg) {
                $('.bvi-panel-container').removeClass('bvi-container').addClass('bvi-container-fluid');
            } else {
                $('.bvi-panel-container').removeClass('bvi-container-fluid').addClass('bvi-container');
            }

            var scroll = (window.pageYOffset !== undefined) ? window.pageYOffset : (document.documentElement || document.body.parentNode || document.body).scrollTop;

            if (scroll > 99) {
                if (Cookies.get("bvi-fixed") == 'true') {
                    $(".bvi-panel").addClass("bvi-fixed-top");
                }
            }

            $(window).scroll(function () {
                if ($(this).scrollTop() >= 99) {
                    if (Cookies.get("bvi-fixed") == 'true') {
                        $(".bvi-panel").addClass('bvi-fixed-top');
                    }
                } else {
                    $(".bvi-panel").removeClass("bvi-fixed-top");
                }
            });

            get();
            get_image();
        }

        if (default_setting.bvi_theme == 'white' ||
            default_setting.bvi_theme == 'black' ||
            default_setting.bvi_theme == 'blue' ||
            default_setting.bvi_theme == 'brown' ||
            default_setting.bvi_theme == 'green') {
            check_bvi_theme = true;
        } else {
            check_bvi_theme = false;
            checkError = ['bvi_theme'];
        }

        if (default_setting.bvi_font == 'times' || default_setting.bvi_font == 'arial') {
            check_bvi_font = true;
        } else {
            check_bvi_font = false;
            checkError = ['bvi_font'];
        }

        if (default_setting.bvi_letter_spacing == 'normal' || default_setting.bvi_letter_spacing == 'average' || default_setting.bvi_letter_spacing == 'big') {
            check_bvi_letter_spacing = true;
        } else {
            check_bvi_letter_spacing = false;
            checkError = ['bvi_letter_spacing'];
        }

        if (default_setting.bvi_line_height == 'normal' || default_setting.bvi_line_height == 'average' || default_setting.bvi_line_height == 'big') {
            check_bvi_line_height = true;
        } else {
            check_bvi_line_height = false;
            checkError = ['bvi_line_height'];
        }

        if (default_setting.bvi_font_size == 0) {
            check_bvi_font_size = false;
            checkError = ['bvi_font_size'];
        } else if (default_setting.bvi_font_size <= 40) {
            check_bvi_font_size = true;
        } else {
            check_bvi_font_size = false;
            checkError = ['bvi_font_size'];
        }

        if (default_setting.bvi_images === false || default_setting.bvi_images === true || default_setting.bvi_images === 'grayscale') {
            check_bvi_images = true;
        } else {
            check_bvi_images = false;
            checkError = ['bvi_images'];
        }

        if (default_setting.bvi_fixed === false || default_setting.bvi_fixed === true) {
            check_bvi_fixed = true;
        } else {
            check_bvi_fixed = false;
            checkError = ['bvi_fixed'];
        }

        if (default_setting.bvi_tts === false || default_setting.bvi_tts === true) {
            check_bvi_tts = true;
        } else {
            check_bvi_tts = false;
            checkError = ['bvi_tts'];
        }

        if (default_setting.bvi_flash_iframe === false || default_setting.bvi_flash_iframe === true) {
            check_bvi_flash_iframe = true;
        } else {
            check_bvi_flash_iframe = false;
            checkError = ['bvi_flash_iframe'];
        }

        if (default_setting.bvi_hide === false || default_setting.bvi_hide === true) {
            check_bvi_hide = true;
        } else {
            check_bvi_hide = false;
            checkError = ['bvi_hide'];
        }

        if (check_bvi_theme === true &&
            check_bvi_font === true &&
            check_bvi_letter_spacing === true &&
            check_bvi_line_height === true &&
            check_bvi_font_size === true &&
            check_bvi_images === true &&
            check_bvi_fixed === true &&
            check_bvi_flash_iframe === true &&
            check_bvi_tts === true &&
            check_bvi_hide === true) {
            if ($(selector).length) {
                $(selector).click(function () {
                    Cookies.set('bvi-panel-active', true, {path: "/", expires: 1});
                    active();
                    bvi_tts_speak('Версия сайта для слабовидящих');
                    return false;
                });
            } else {
                console.log('Bvi console: Неправильный параметр - [bvi_target]');
            }
            active();
        } else {
            console.log('Bvi console: Неправильный параметр - [' + checkError + ']');
        }
    };
})(jQuery);
